
/* Name: main.c
      ,     SWI  ,   .
	      ,      .
*/

#include <string.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <avr/wdt.h>
#include <avr/eeprom.h>
#include <util/delay.h>
#include <util/delay_basic.h>
#include "debug.h"

unsigned int FCnt1; // 

unsigned char TimerCnt2;

unsigned long long F;

double p = 0.0;


typedef int TArray[5];

union TObj
{
    TArray Array;
	int B;
};

struct St
{
    union TObj List[5];
	int * IntArray[5];
} StVar;


ISR(TIMER0_OVF_vect)
{//     
   FCnt1++;
   //Dbg(); 
}


ISR(TIMER1_OVF_vect)
{//     
   
   if (TimerCnt2 == 30)
   {
       TCCR1B= 0;//   
       TCCR0 = 0; 	   

       Dbg();
	   unsigned char FCnt0 = TCNT0;
	   unsigned int TimerCnt0 = TCNT1;

       Dbg();
	   if (FCnt0 < 20) //      
	   {
	       Dbg();

		   if (TIFR & 2) //    
		   {
		       FCnt1++;
			   Dbg();
		   }
	   }

       int i;
	   for (i = 0; i < 5; i++)
	   {
	       StVar.List[i].Array[0] = i;
		   StVar.List[i].Array[1] = i + 1;
		   StVar.List[i].Array[2] = i + 2;
		   StVar.List[i].Array[3] = i + 3;
		   StVar.List[i].Array[4] = i + 4;
		   Dbg();
		   StVar.IntArray[i] = &(StVar.List[i].B);	
		   Dbg();
	   }
	   
	   unsigned long Tikes = (unsigned long)FCnt0 + (unsigned long)256 * FCnt1;
	   Dbg();

	   unsigned long Time = ((unsigned long)0x1E0000 | TimerCnt0);
	   Dbg();

	   unsigned long long X = (unsigned long long)20000000 * Tikes;	
	   Dbg();

       F = X / Time;
	   p = 1;
	   Dbg();
       
	   TimerCnt2 = 0;
	   // 
	   

	   TCNT1 = 0;
	   Dbg();

       TCNT0 = 0;
	   Dbg();

       FCnt1 = 0; 
	   Dbg();
       
	   TIFR &= 2;//     0,    
	   Dbg();
	   
	   TCCR1B= 1; //  
       TCCR0 = 7; // -  

	   
   }
   else
   {
       TimerCnt2++;
   } 
}

int main(void)
{
   TIMSK = 0x82; //       
   Dbg();
   //   :      0  0- 
   //     0-  8,  1- - 1.
   TCCR1A = 0;      				 
   Dbg();
   sei();
   Dbg();
   TCCR1B= 1; //  
   TCCR0 = 7; // -  
   while (1);
   
}




